/**************************************************************************************

Copyright (c) Hilscher Gesellschaft fuer Systemautomation mbH. All Rights Reserved.

***************************************************************************************

  $Id: DownloadDlg.h 12626 2018-10-30 14:55:29Z LuisContreras $:

  Description:
    File/Firmware/Config File Download Dialog

  Changes:
    Date        Description
    -----------------------------------------------------------------------------------
    2006-07-04  initial version

**************************************************************************************/

/////////////////////////////////////////////////////////////////////////////
/// \file DownloadDlg.h
///   File/Firmware/Config File Download Dialog
/////////////////////////////////////////////////////////////////////////////

#pragma once

#include "BaseDialog.h"
#include "afxcmn.h"
#include "afxwin.h"

///////////////////////////////////////////////////////////////////////////////////////////
/// File/Firmware/Config File Download Dialog
///////////////////////////////////////////////////////////////////////////////////////////
class CDownloadDlg : public CBaseDialog
{
	DECLARE_DYNAMIC(CDownloadDlg)

public:

  /////////////////////////////////////////////////////
  /// Structure for storing download mode specific settings
  /////////////////////////////////////////////////////
  typedef struct DOWNLOAD_MODEStag
  {
    LPCTSTR       szMode;               //!< Human readable mode
    unsigned long ulMode;               //!< Mode to pass to driver
    LPCTSTR       szFileFilter;         //!< File extension filter to use for CFileDialog class
    
    CString       csLastShortFilename;  //!< Last valid Short file name for download mode
    CString       csLastFullFilename;   //!< Last valid full file name for download mode

  } DOWNLOAD_MODES, *PDOWNLOAD_MODES;

  CDownloadDlg(CWnd* pParent = NULL);
	virtual ~CDownloadDlg();

// Dialog Data
	enum { IDD = IDD_DOWNLOAD };

protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support

	DECLARE_MESSAGE_MAP()
  
  CProgressCtrl   m_cDownloadProgressCtrl;   //!< Download progress indication progress bar control
  CComboBox       m_cDownloadModeCtrl;       //!< Download mode selection combobox control

  unsigned long   m_ulChannel;               //!< Channel number, the download is made for
  unsigned char*  m_pabFileData;             //!< Data read during last download
  unsigned long   m_ulFileSize;              //!< Read data file size
  PDOWNLOAD_MODES m_ptMode;                  //!< Currently selected download mode

  static DWORD WINAPI DownloadThread(LPVOID pvParam);

public:
  virtual BOOL OnInitDialog();
  
  afx_msg void OnCbnSelchangeCbDownloadmode();
  afx_msg void OnEnKillfocusEdtChannel();
  afx_msg void OnBnClickedBtnSelectfile();
  afx_msg void OnBnClickedBtnDownload();

  void         ThreadFunction(void);
  void         OnUpdateDevice(CCifXDeviceBase* pcDevice);
  void         UpdateProgress(unsigned long ulStep, unsigned long ulMaxStep, char bFinished, long lError);
};
